#include "MTTXCAViewer.h"

MTSimpleResourceTemplate	MTTXCAViewer::kTXCAFormatTemplate =
{
	{
		ONI_RESOURCE_HEADER
		
		{	kTypeUInt16 | kTypeIsFiller |
			kTypeDataBlock | DATA_AREA_1(10),		"Filler" },
		
		{	kTypeUInt32 | kTypeStoreToVariable |
			DATA_AREA_1(0)/* | kTypeIsFiller*/,		"Number of Entries" },	// 2
		
		{	kTypeStartSection | DATA_AREA_1(0),		"Entries" },
		
		{	kTypeFloat,								"X" },					// 3
		{	kTypeFloat,								"Y" },					// 4
		
		{	kTypeEndSection },
		
		{	0 }
	}
};

void MTTXCAViewer::PostProcess(void)
{
	UInt32	numEntries = GetResourceEntry(2)->data;
	
	entries.resize(numEntries);
	
	for(UInt32 i = 0; i < numEntries; i++)
	{
		MTParsedResourceEntry	* entry;
		
		entry = GetResourceEntry(3 + (i * 2));
		entries[i].x = *((float *)&entry->data);
		
		entry = GetResourceEntry(4 + (i * 2));
		entries[i].y = *((float *)&entry->data);
	}
}